---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.41
-- DDL to create packages and procedures
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 12, 2000 MSW
-- Date Updated: October 18, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092700 Added Change Log
-- MSW 092700 Added Header Comments
-- AHW 092700 Changed error codes for all stored procedures
-- MSW 092700 Added 'SHOW ERRORS' statement after each package creation
-- MSW 100200 Added unique constraint exception handling to pkg_ALKINDI_EVALUATION.sp_INSERT_Evals
-- MSW 100500 Removed WEB_EVALUATION Object
-- MSW 100500 Removed EVALUATIONS_array Varray
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_USER_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_USER_DATA
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_ALKINDEX_DATA to pkg_ALKINDI_EVALUATION.sp_SEL_ALKINDEX_DATA
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC1
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC2
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC1 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC1
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2 to pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC2
-- MSW 100600 Moved pkg_ALKINDI_RECOMMENDATION.sp_SEL_NEW_PROD_DATA_BY_USER to pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_USER
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 100900 Renamed USER_CLUSTER_MEAN_DISTANCE to USER_UC_STAT
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to USER_UC_STAT to enhance query performance
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_MEAN_DISTANCE to USER_UC_STAT
-- AHW 100900 Renamed all "STAT" columns that contained "TOTAL" to "TOT"
-- AHW 100900 Renamed all "STAT" columns that contained "W" to "WGT"
-- AHW 100900 Renamed all "STAT" table names that contained USER_CLUSTER to UC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT_CLUSTER to PC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT to PROD
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT to PROD (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT_CLUSTER to PC (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained USER_CLUSTER to UC (except foreign key references)
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_DISTANCE to USER_PROD_UC_STAT
-- AHW 100900 Renamed USER_CLUSTER_DISTANCE to USER_PROD_UC_STAT
-- MSW 100900 Added pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_USER
-- MSW 100900 Removed OMEGA as an input parameter in pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_USER. OMEGA will be handled in ReCalcStats
-- MSW 100900 Removed OMEGA as an input parameter in pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2. OMEGA will be handled in ReCalcStats
-- MSW 100900 Removed OMEGA as an input parameter in pkg_ALKINDI_RECOMMENDATION.sp_SEL_OLD_PROD_DATA_BY_PC2. OMEGA will be handled in ReCalcStats
-- AHW 101000 Renamed all "STAT" columns that contained FRACTION to FRN
-- MSW 101500 Renamed pkg_ALKINDI_EVALUATION.sp_SEL_Evals_by_User to sp_SEL_ProdEval_By_User
-- MSW 101500 Added pkg_ALKINDI_EVALUATION.sp_SEL_PROD_BY_USER_DATA
-- MSW 101500 Revised all SP to use denormalized stat tables to increase performance
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 101800 Added NVL condition to sp_SEL_PROD_BY_USER_DATA to handle users that haven't rated any movies (user_id=0)
-- MSW 101800 Changed pkg_ALKINDI_EVALUATION.sp_SEL_PROD_BY_USER_DATA to return product_type_id as well as product_id
-- MSW 101800 Changed pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC1 to return product_type_id as well as product_id
-- MSW 101800 Changed pkg_ALKINDI_EVALUATION.sp_SEL_NEW_PROD_DATA_BY_PC2 to return product_type_id as well as product_id
-- MSW 101800 Changed pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC1 to return product_type_id as well as product_id
-- MSW 101800 Changed pkg_ALKINDI_EVALUATION.sp_SEL_OLD_PROD_DATA_BY_PC2 to return product_type_id as well as product_id
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_EVALUATION				-- BK092400
AS
  TYPE EVALUATION_cursor_type is REF CURSOR;

  PROCEDURE sp_INSERT_Evals(
     i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
     i_PRODUCT_ID				IN		EVALUATION.PRODUCT_ID%TYPE,
     i_EVALUATION_SCALE_ID		IN		EVALUATION.EVALUATION_SCALE_ID%TYPE);

    PROCEDURE sp_SEL_ProdEval_By_User(
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_USER_DATA(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_USER(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	i_OMEGA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	i_DELTA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	i_OMEGA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	i_DELTA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_USER(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_PROD_BY_USER_DATA (
	i_PRODUCT_CLUSTER_ID		IN		PROD_UC_STAT.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_ID				IN		USER_STAT.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_CNT_PROD_SEEN_BY_USER (
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_TOT_PROD_SEEN			OUT		NUMBER,
	o_ERROR_CODE			OUT		NUMBER);

END pkg_ALKINDI_EVALUATION;
/

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_EVALUATION				-- BK092400  - Timestamp Added
AS

-- Insert evaluations into the table EVALUATION. When there are duplicate values on index, then insert the evaluations into 
-- EVALUATION_HISTORY. Simultaneously, the EVALUATION table is updated by the new records. 
 
  PROCEDURE sp_INSERT_Evals(
     i_USER_ID				IN	EVALUATION.USER_ID%TYPE,
     i_PRODUCT_ID				IN	EVALUATION.PRODUCT_ID%TYPE,
     i_EVALUATION_SCALE_ID		IN	EVALUATION.EVALUATION_SCALE_ID%TYPE)

   IS 
	ERR_NUM	NUMBER; 
	ERR_MSG 	VARCHAR2(255);
   BEGIN

	INSERT INTO EVALUATION(USER_ID, PRODUCT_ID, EVALUATION_SCALE_ID, EVALUATION_TIMESTAMP)
           VALUES (i_USER_ID,i_PRODUCT_ID,i_EVALUATION_SCALE_ID, sysdate);

   EXCEPTION
	WHEN DUP_VAL_ON_INDEX THEN
		INSERT 
		  INTO EVALUATION_HISTORY (USER_ID, PRODUCT_ID, EVALUATION_SCALE_ID, OLD_EVALUATION_TIMESTAMP,
		  NEW_EVALUATION_TIMESTAMP)
	     (SELECT USER_ID
		     , PRODUCT_ID
		     , EVALUATION_SCALE_ID
		     , EVALUATION_TIMESTAMP
		     , SYSDATE
		  FROM EVALUATION
		 WHERE USER_ID = i_USER_ID
		   AND PRODUCT_ID = i_USER_ID);

		UPDATE EVALUATION 
		   SET EVALUATION_SCALE_ID=i_EVALUATION_SCALE_ID
		     , EVALUATION_TIMESTAMP=sysdate
		 WHERE USER_ID = i_USER_ID
		   AND PRODUCT_ID = i_PRODUCT_ID;

	err_num := SQLCODE; 
	err_msg := SQLERRM;
	INSERT INTO errors								-- errors generated during the execution of this 
	VALUES (err_num, err_msg); 							-- stored procedure is recorded in the errors table

 END sp_INSERT_Evals;

-- ==========================================================================================
-- Selecting product evaluations by users

  PROCEDURE sp_SEL_ProdEval_By_User(							-- MSW092500 - Corrected cursor
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
   OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_ID
	     , EVALUATION_SCALE_ID
        FROM EVALUATION
       WHERE USER_ID = i_USER_ID;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6553;						-- general errors when selcting product evaluations
    CLOSE o_Evaluation_cursor_type;							-- by users
 END sp_SEL_ProdEval_By_User;


-- ==========================================================================================
-- Selecting user data from USER_DATA_STAT by passing in the user_id

  PROCEDURE sp_SEL_USER_DATA(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR
	SELECT PRODUCT_CLUSTER_ID 
	     , NI
	     , RI
	     , EI
	     , FI
	     , BI
	     , EAVE
	     , RAVE
	  FROM USER_DATA_STAT
	 WHERE USER_ID = i_USER_ID;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_USER_DATA; 

-- ==========================================================================================
-- Selecting new product data by product cluster by selecting product_id from PROD_PC_STAT where the 
-- total number of user evaluations is less than the total number of user evaluations in the PROD_STAT 
-- table or the fraction of users that have seen the product is greater than the fraction of users that 
-- have seen the product in the PROD_STAT table

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT S.PRODUCT_ID, S.PRODUCT_TYPE_ID
	  FROM PROD_PC_STAT S
	 WHERE S.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND S.NEW_ADDITION_IND = 1
	   AND (S.TOT_USER_EVAL < i_Q
	    OR S.FRN_USER_SEEN > i_R);

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_NEW_PROD_DATA_BY_PC1;

-- ==========================================================================================
-- Selecting new product data by product cluster by selecting product_id from PROD_PC_STAT 
-- where the total number of user evaluations is greater than the number of user evaluations 
-- in the PROD_STAT table and the fraction of users that have seen the product is 
-- less than the fraction of users seen the product in the PROD_STAT table

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT S.PRODUCT_ID, S.PRODUCT_TYPE_ID
	  FROM PROD_PC_STAT S
	 WHERE S.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND S.NEW_ADDITION_IND = 1
	   AND S.TOT_USER_EVAL > i_Q
	   AND S.FRN_USER_SEEN < i_R;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_NEW_PROD_DATA_BY_PC2;
-- ==========================================================================================
-- Selecting new product data by given users 

  PROCEDURE sp_SEL_NEW_PROD_DATA_BY_USER(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_CLUSTER_ID, NEW_PROD_EPI AS EPI, NEW_PROD_NI AS NI, NEW_PROD_EI AS EI, NEW_PROD_MI AS MI
	  FROM USER_DATA_STAT
	 WHERE USER_ID = i_USER_ID;

  EXCEPTION
	WHEN OTHERS THEN
    o_ERROR_CODE  := -1;
    CLOSE o_EVALUATION_cursor_type;
END sp_SEL_NEW_PROD_DATA_BY_USER;

-- ==========================================================================================
-- Selecting old product data by product cluster where its data already exists in sp_SEL_NEW_PROD_DATA_BY_PC1  

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC1(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	i_OMEGA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	i_DELTA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT S.PRODUCT_ID, S.PRODUCT_TYPE_ID
	  FROM PROD_PC_STAT S
	 WHERE S.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND S.NEW_ADDITION_IND = 0
	   AND (S.TOT_USER_EVAL < i_Q
	    OR S.FRN_USER_SEEN > i_R)
	   AND S.TOT_USER_SEEN < i_OMEGA
	   AND S.TOT_USER_SEEN > i_DELTA;

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_OLD_PROD_DATA_BY_PC1;

-- ==========================================================================================
-- Selecting old product data by product cluster where its data already exists in sp_SEL_NEW_PROD_DATA_BY_PC2

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_PC2(
	i_PRODUCT_CLUSTER_ID		IN		PRODUCT_CLUSTER.PRODUCT_CLUSTER_ID%TYPE,
	i_R					IN		PROD_STAT.FRN_USER_SEEN%TYPE,
	i_Q					IN		PROD_STAT.TOT_USER_EVAL%TYPE,
	i_OMEGA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	i_DELTA				IN		PROD_STAT.TOT_USER_SEEN%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT S.PRODUCT_ID, S.PRODUCT_TYPE_ID
	  FROM PROD_PC_STAT S
	 WHERE S.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND S.NEW_ADDITION_IND = 0
	   AND S.TOT_USER_EVAL > i_Q
	   AND S.FRN_USER_SEEN < i_R
	   AND (S.TOT_USER_SEEN < i_OMEGA
	   AND S.TOT_USER_SEEN > i_DELTA);

  EXCEPTION
	WHEN OTHERS THEN
      o_ERROR_CODE  := -1;
      CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_OLD_PROD_DATA_BY_PC2;

-- ==========================================================================================
-- Selecting old product data by given users

  PROCEDURE sp_SEL_OLD_PROD_DATA_BY_USER(
	i_USER_ID				IN		USER_ID.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT PRODUCT_CLUSTER_ID, OLD_PROD_OME_EPI AS EPI, OLD_PROD_OME_NI AS NI, OLD_PROD_OME_EI AS EI, OLD_PROD_OME_MI AS MI
	  FROM USER_DATA_STAT
	 WHERE USER_ID = i_USER_ID;

  EXCEPTION
	WHEN OTHERS THEN
    o_ERROR_CODE  := -1;
    CLOSE o_EVALUATION_cursor_type;
  END sp_SEL_OLD_PROD_DATA_BY_USER;

-- ==========================================================================================
-- Selecting product by user data, ordering the result by its average in a descending order
-- MSW 101800, NVL(MIN(),0) was added to return all products in order when user_id of "0" is an input

  PROCEDURE sp_SEL_PROD_BY_USER_DATA (
	i_PRODUCT_CLUSTER_ID		IN		PROD_UC_STAT.PRODUCT_CLUSTER_ID%TYPE,
	i_USER_ID				IN		USER_STAT.USER_ID%TYPE,
	o_EVALUATION_cursor_type	OUT		EVALUATION_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;
	OPEN o_EVALUATION_cursor_type FOR

	SELECT S.PRODUCT_ID, S.PRODUCT_TYPE_ID
	  FROM PROD_PC_STAT S
	 WHERE S.PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID
	   AND S.FRN_USER_SEEN >= 
     (SELECT MAX(FRN_SEEN_BY_PC_PARA) 
	  FROM EVAL_PARAMETER
	 WHERE TOT_EVAL_BY_USER_PC_PARA > 
     (SELECT NVL(MIN(TOT_PROD_EVAL),0)
	  FROM USER_PC_STAT
	 WHERE USER_ID = i_USER_ID
	   AND PRODUCT_CLUSTER_ID = i_PRODUCT_CLUSTER_ID))
	   AND PRODUCT_ID NOT IN
     (SELECT PRODUCT_ID
	  FROM EVALUATION
	 WHERE USER_ID = i_USER_ID)
    ORDER BY AVG_V DESC;

  EXCEPTION
	WHEN OTHERS THEN
    o_ERROR_CODE  := -1;
    CLOSE o_EVALUATION_cursor_type;
END sp_SEL_PROD_BY_USER_DATA;

-- ==========================================================================================
-- Counting the number of times that a product has been seen by users 

  PROCEDURE sp_CNT_PROD_SEEN_BY_USER (
	i_USER_ID				IN		EVALUATION.USER_ID%TYPE,
	o_TOT_PROD_SEEN			OUT		NUMBER,
	o_ERROR_CODE			OUT		NUMBER)

   IS BEGIN
	o_ERROR_CODE	:= 0;

	SELECT COUNT(EVALUATION_SCALE_ID) INTO o_TOT_PROD_SEEN
	  FROM EVALUATION
	 WHERE USER_ID = i_USER_ID
	   AND EVALUATION_SCALE_ID >= 1;

  EXCEPTION
	WHEN OTHERS THEN
    o_ERROR_CODE  := -1;
END sp_CNT_PROD_SEEN_BY_USER;



END pkg_ALKINDI_EVALUATION;
/

SHOW ERRORS
